///////////////////////////////////////////////////////////////////////////////////
//No part of this file can be copied or released without the consent of 
//Avalanche Technology
//  									
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
//  									
//  Avalanche Technology Inc., Proprietary and Confidential	   *
//  									
//   Release:  3.0    Date 5/25/2023  	
//  						
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//  PART DESCRIPTION:
//
//  Technology: 22nm pMTJ STT-MRAM
//  Part:       AS30XGB32
//
//  Description: 1 Gigabit/4 Gigabit PARALLEL PERSISTENT SRAM MEMORY
//
////////////////////////////////////////////////////////////////////////////////////
//  FILE CONTENTS : Testbench for AS30XGB32
//
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// MODULE DECLARATION                                                             //
////////////////////////////////////////////////////////////////////////////////////
`timescale 1ns/1ps

//`include "ppsram_as30xgb32.v"
//`include "stimulus.v"

module test;

  wire CE, OE, WE;
  wire [31:0] DQ;
    

  wire [26:0] ADDR;

  wire PGn, CRn, INTn;
   
  ppsram_as3xxxb32 M0 (
    .En(CE),
    .Gn(OE),
    .Wn(WE),
    .PGn(PGn),
    .CRn(CRn),
    .INTn(INTn),
    .ADDR(ADDR[24:0]),
    .DQ(DQ)
    );

  stimulus inst_stim (
    .PGn(PGn),
    .CRn(CRn),
    .En(CE),
    .Gn(OE),
    .Wn(WE),
    .ADDR(ADDR),
    .DQ(DQ)
    );

  initial begin
//    $vcdpluson;
//    $shm_open("test.shm");
//    $shm_probe(test,"ACM");
//     $fsdbDumpfile("test.fsdb");
//     $fsdbDumpvars(test)
     $dumpfile("test.vcd");
     $dumpvars(0,test);
  end
endmodule
